--- @meta

-- This file is autogenerated. Do not edit this file manually. Your changes will be ignored.
-- More information: https://github.com/MWSE/MWSE/tree/master/docs

--- A class to facilitate printing log messages.
--- A new one can be constructed by simply calling `mwse.Logger.new()`.
--- See the [Quickstart Guide](../guides/logging.md#quickstart)
--- for more information.
--- 
--- @class mwseLogger
--- @field abbreviateHeader boolean If set to `true`, the header portion of all logging messages will be shortened. 
--- For example, suppose the following log message is written on line `20` of the file `My Mod/Skills/Player/Combat/swords.lua`.
--- ```lua
--- log("My message")
--- ```
--- Then the resulting output to MWSE.log would be:
--- ```
--- -- abbreviateHeader == true:
--- [My Mod | s/p/c/swords:20  | D] My message
--- -- abbreviateHeader == false:
--- [My Mod | skills/player/combat/swords.lua:20  | DEBUG] My message
--- ```
--- This does not affect how the "body" of log messages are displayed.
--- @field filepath string The path to the file this `mwseLogger` was created in. This will be relative to the `modDir`.
--- 
--- For example, if this `mwseLogger` was constructed in `mods/My Mod/main.lua`, then the `filepath` will be `main.lua`.
--- @field formatter fun(self: mwseLogger, record: mwseLoggerRecord, ...: string|any|fun(...): ...): string This is an advanced option and should be used with care.
--- It allows specifying a custom formatter, allowing for more fine-tuned control over how log messages are printed.
--- If supplying a formatter, you are responsible for also including the "header" portion of the log.
--- These can be created by calling the `protected` `makeHeader` method.
--- 
--- Some examples can be found in the `logger/formatters.lua` folder of the core library.
--- 
--- @field includeTimestamp boolean If set to `true`, all the logged messages will include a timestamp.
--- @field level mwseLogger.logLevel The current logging level.
--- @field logToConsole boolean If `true`, all the logged messages will also be logged to the in-game console.
--- @field modDir string The directory that your mod lives in. This is relative to `Data Files/MWSE/mods`.
--- @field modName string Name of the mod, also counts as unique id of the logger.
--- @field moduleName any Associates a logger with a particular "module". 
--- The `moduleName` will be printed in logging messages next to the `modName`.
--- What does and does not constitute a "module" is entirely subjective. Use this field as you please. 
--- This can be useful if the `filepath` alone is not enough to distinguish what code is reponsible for issuing a log message.
--- For example, the MWSE dependency management system uses a `moduleName` to alert the user about which mod had a dependency problem.
--- 	
--- @field outputFile string|boolean Determines where logging messages are printed. If `false`, log messages are printed to `MWSE.log`. 
--- If it's a `string`, then logging messages will be printed to `Data Files/MWSE/logs/<log.outputFile>.log`.
--- 
--- Setting this to `true` is the same as writing `log.outputFile = log.modDir`.
mwseLogger = {}

--- Gets a logger associated with a particular `modDir`. You can also filter by `filepath` as well.
--- @param modDir string The directory of mod to retrieve the loggers for. This argument corresponds to the `lua-mod` field of the mod's metadata file.
--- @param filepath? string *Optional*. The filepath to retrieve the logger for. This is relative to `modDir` and corresponds to the `filepath` field of the logger to retrieve.
--- @return mwseLogger|nil logger The logger, if it exists.
function mwseLogger.get(modDir, filepath) end

--- Gets a logger with a specific `modName`. You should use `mwseLogger.get` instead.
--- @deprecated
--- @param modName string The name of the mod to retrieve the logger for.
--- @return mwseLogger|nil logger The logger, if it exists.
function mwseLogger.getLogger(modName) end

--- Gets all the loggers registered to a particular `modDir`.
--- @param modDir string The directory of mod to retrieve the loggers for. This argument corresponds to the `lua-mod` field of the mods metadata file.
--- @return mwseLogger[]|nil loggers The loggers, if they exist.
function mwseLogger.getLoggers(modDir) end

--- Creates a new logger based on the input parameters.
--- @param params? mwseLogger.new.params This table accepts the following values:
--- 
--- `modName?`: string — *Optional*. The name of MWSE mod associated to this Logger. This will be retrieved automatically if not provided.
--- 
--- `moduleName?`: string — *Optional*. The module this Logger is associated with. This can be useful for distinguishes which parts of your mod produce certain log messages. This will be displayed next to the name of the mod, in parentheses.
--- 
--- `level?`: mwseLogger.logLevel|mwseLogger.logLevelString — *Default*: `mwse.logLevel.info`. The logging level for all loggers associated to this mod.
--- 
--- `logToConsole?`: boolean — *Default*: `false`. Should the output also be written to the in-game console?
--- 
--- `outputFile?`: boolean|string — *Default*: `false`. The path of the output file to write log messages in. This path is taken relative to `Data Files/MWSE/logs/`. If not provided, log messages will be written to `MWSE.log`. If `true`, then the `modDir` will be used as the output path.
--- 
--- `includeTimestamp?`: boolean — *Default*: `true`. Should timestamps be included in logging messages? The timestamps are relative to the time that the game was launched.
--- 
--- `abbreviateHeader?`: boolean — *Default*: `false`. Should the headers be abbreviated?
--- 
--- `formatter?`: fun(self: mwseLogger, record: mwseLoggerRecord, ...: string|any|fun(...): ...): string — *Optional*. A custom formatter. This lets you customize how your logging messages are formatted. If not provided, the default formatter will be used.
--- @return mwseLogger log The newly created logger.
function mwseLogger.new(params) end

---Table parameter definitions for `mwseLogger.new`.
--- @class mwseLogger.new.params
--- @field modName? string *Optional*. The name of MWSE mod associated to this Logger. This will be retrieved automatically if not provided.
--- @field moduleName? string *Optional*. The module this Logger is associated with. This can be useful for distinguishes which parts of your mod produce certain log messages. This will be displayed next to the name of the mod, in parentheses.
--- @field level? mwseLogger.logLevel|mwseLogger.logLevelString *Default*: `mwse.logLevel.info`. The logging level for all loggers associated to this mod.
--- @field logToConsole? boolean *Default*: `false`. Should the output also be written to the in-game console?
--- @field outputFile? boolean|string *Default*: `false`. The path of the output file to write log messages in. This path is taken relative to `Data Files/MWSE/logs/`. If not provided, log messages will be written to `MWSE.log`. If `true`, then the `modDir` will be used as the output path.
--- @field includeTimestamp? boolean *Default*: `true`. Should timestamps be included in logging messages? The timestamps are relative to the time that the game was launched.
--- @field abbreviateHeader? boolean *Default*: `false`. Should the headers be abbreviated?
--- @field formatter? fun(self: mwseLogger, record: mwseLoggerRecord, ...: string|any|fun(...): ...): string *Optional*. A custom formatter. This lets you customize how your logging messages are formatted. If not provided, the default formatter will be used.

--- Logs and raises an error if the value of its argument v is false (i.e., `nil` or `false`); otherwise, returns all its arguments.
--- @generic T
--- @param v? T *Optional*. No description yet available.
--- @param message string|fun(...): ... No description yet available.
--- @param ...? any *Optional*. Formatting arguments. These are passed to `string.format`. Tables and userdata values are pretty printed.
--- @return T v No description yet available.
--- @return any ... No description yet available.
function mwseLogger:assert(v, message, ...) end

--- Log a `DEBUG` message. This will only be printed if the current logging level is `DEBUG` or higher.
--- If multiple arguments are passed, then they will be passed to `string.format`.
--- 	
--- All `table` or `userdata` arguments will be prettyprinted.
--- You can also pass a function as the first or second parameter to lazily evaluate log statements.
--- See the [Writing More Useful Log Messages](../guides/logging.md#writing-more-useful-log-messages) 
--- and [Passing Functions to Logging Methods](../guides/logging.md#passing-functions-to-the-logging-methods) 
--- sections of the [Logging Guide](../guides/logging.md) 
--- for more information.
--- 
--- !!! note "Shorthand Syntax"
--- 	This method can also be called by writing `log(message, ...)` instead of `log:debug(message, ...)`.
--- 
--- 
--- @param message string|fun(...): ... No description yet available.
--- @param ...? any *Optional*. Formatting arguments. These are passed to `string.format`. Tables and userdata values are pretty printed.
function mwseLogger:debug(message, ...) end

--- 		Returns true if the messages of the given log level will be logged.
--- 		This method is deprecated. It is recommended to either use
--- 		[lazy evaluation](../guides/logging.md#passing-functions-to-the-logging-methods)
--- 		or check the logging level directly, e.g.:
--- 		```lua
--- 		if log.level >= mwse.logLevel.debug then
--- 			-- do stuff
--- 		end
--- 		```
--- 	
--- @deprecated
--- @param logLevel mwseLogger.logLevel|mwseLogger.logLevelString No description yet available.
--- @return boolean doLog No description yet available.
function mwseLogger:doLog(logLevel) end

--- Log an `ERROR` message. This will only be printed if the current logging level is `ERROR` or higher.
--- If multiple arguments are passed, then they will be passed to `string.format`.
--- 	
--- All `table` or `userdata` arguments will be prettyprinted.
--- You can also pass a function as the first or second parameter to lazily evaluate log statements.
--- See the [Writing More Useful Log Messages](../guides/logging.md#writing-more-useful-log-messages) 
--- and [Passing Functions to Logging Methods](../guides/logging.md#passing-functions-to-the-logging-methods) 
--- sections of the [Logging Guide](../guides/logging.md) 
--- for more information.
--- 
--- @param message string|fun(...): ... No description yet available.
--- @param ...? any *Optional*. Formatting arguments. These are passed to `string.format`. Tables and userdata values are pretty printed.
function mwseLogger:error(message, ...) end

--- Gets a `string` representation of the current logging level.
--- @param level? mwseLogger.logLevel *Optional*. If provided, a string representation of this logging level will be returned. If `nil`, then a string representation of the current logging level will be returned.
--- @return string levelString No description yet available.
function mwseLogger:getLevelString(level) end

--- Log an `INFO` message. This will only be printed if the current logging level is `INFO` or higher.
--- If multiple arguments are passed, then they will be passed to `string.format`.
--- 	
--- All `table` or `userdata` arguments will be prettyprinted.
--- You can also pass a function as the first or second parameter to lazily evaluate log statements.
--- See the [Writing More Useful Log Messages](../guides/logging.md#writing-more-useful-log-messages) 
--- and [Passing Functions to Logging Methods](../guides/logging.md#passing-functions-to-the-logging-methods) 
--- sections of the [Logging Guide](../guides/logging.md) 
--- for more information.
--- 
--- @param message string|fun(...): ... No description yet available.
--- @param ...? any *Optional*. Formatting arguments. These are passed to `string.format`. Tables and userdata values are pretty printed.
function mwseLogger:info(message, ...) end

--- Changes the `abbreviateHeader` field of this logger.
--- 	
--- This function does exactly the same thing as `log.abbreviateHeader = newAbbreviateHeader`. 
--- Use whichever one you prefer.
--- 
--- @param newAbbreviateHeader boolean No description yet available.
function mwseLogger:setAbbreviateHeader(newAbbreviateHeader) end

--- Changes the `formatter` field of this logger.
--- 
--- This function does exactly the same thing as writing `log.formatter = newFormatter`.
--- Use whichever one you prefer.
--- 
--- @param newFormatter fun(self: mwseLogger, record: mwseLoggerRecord, ...: string|any|fun(...): ...): string No description yet available.
function mwseLogger:setFormatter(newFormatter) end

--- Changes the `includeTimestamp` field of this logger.
--- 	
--- This function does exactly the same thing as `log.includeTimestamp = newIncludeTimestamp`. 
--- Use whichever one you prefer.
--- 
--- @param newIncludeTimestamp boolean No description yet available.
function mwseLogger:setIncludeTimestamp(newIncludeTimestamp) end

--- Set the log level. 
--- You can pass in either a string representation of a logging level, or the corresponding numerical constant found in the `mwse.logLevel` table.
--- The options are: `"TRACE"`, `"DEBUG"`, `"INFO"`, `"WARN"`, `"ERROR"` and `"NONE"`.
--- 
--- This function does exactly the same thing as writing `log.level = newLogLevel`. 
--- Use whichever one you prefer.
--- 
--- @param newLogLevel mwseLogger.logLevel|mwseLogger.logLevelString No description yet available.
function mwseLogger:setLevel(newLogLevel) end

--- Set the log level. Use `mwseLogger:setLevel` instead.
--- @deprecated
--- @param newLogLevel mwseLogger.logLevel|mwseLogger.logLevelString No description yet available.
function mwseLogger:setLogLevel(newLogLevel) end

--- Changes the `modName` field of this logger.
--- 	
--- This function does exactly the same thing as writing `log.modName = newModName`. 
--- Use whichever one you prefer.
--- 
--- @param newModName string No description yet available.
function mwseLogger:setModName(newModName) end

--- Changes the `moduleName` field of this logger.
--- 	
--- This function does exactly the same thing as writing `log.moduleName = newModuleName`. 
--- Use whichever one you prefer.
--- 
--- @param newModName string No description yet available.
function mwseLogger:setModuleName(newModName) end

--- Set the output file. If set, logs will be sent to a file of this name.
--- 
--- This function does exactly the same thing as `log.outputFile = newOutputFile`. 
--- Use whichever one you prefer.
--- 
--- @param outputFile string|boolean If `true`, then the `modName` field will be used as the filepath. If `false`, no custom output file will be used.
function mwseLogger:setOutputFile(outputFile) end

--- Log a `TRACE` message. This will only be printed if the current logging level is `TRACE`.
--- If multiple arguments are passed, then they will be passed to `string.format`.
--- 	
--- All `table` or `userdata` arguments will be prettyprinted.
--- You can also pass a function as the first or second parameter to lazily evaluate log statements.
--- See the [Writing More Useful Log Messages](../guides/logging.md#writing-more-useful-log-messages) 
--- and [Passing Functions to Logging Methods](../guides/logging.md#passing-functions-to-the-logging-methods) 
--- sections of the [Logging Guide](../guides/logging.md) 
--- for more information.
--- 
--- @param message string|fun(...): ... No description yet available.
--- @param ...? any *Optional*. Formatting arguments. These are passed to `string.format`. Tables and userdata values are pretty printed.
function mwseLogger:trace(message, ...) end

--- Log a `WARN` message. This will only be printed if the current logging level is `WARN` or higher.
--- If multiple arguments are passed, then they will be passed to `string.format`.
--- 	
--- All `table` or `userdata` arguments will be prettyprinted.
--- You can also pass a function as the first or second parameter to lazily evaluate log statements.
--- See the [Writing More Useful Log Messages](../guides/logging.md#writing-more-useful-log-messages) 
--- and [Passing Functions to Logging Methods](../guides/logging.md#passing-functions-to-the-logging-methods) 
--- sections of the [Logging Guide](../guides/logging.md) 
--- for more information.
--- 
--- @param message string|fun(...): ... No description yet available.
--- @param ...? any *Optional*. Formatting arguments. These are passed to `string.format`. Tables and userdata values are pretty printed.
function mwseLogger:warn(message, ...) end

--- Writes an `INFO` message saying this mod has been initialized. 
--- If your mod has [metadata file](../guides/metadata.md#package-section) that specifies its current version,
--- then that will also be included in the initialization message. 
--- You may also supply a version number directly as an argument to this method.
--- @param version? string *Optional*. The current version of your mod. If not provided, the logger will attempt to retrieve it from your mod's metadata file.
function mwseLogger:writeInitMessage(version) end

